<?php

//doctor_action.php
use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;

require_once '../vendor/autoload.php';
include('../class/Appointment.php');

//
$options = new QROptions(
  [
    'eccLevel' => QRCode::ECC_L,
    'outputType' => QRCode::OUTPUT_MARKUP_SVG,
    'version' => 5,
  ]
);

//
use PhpOffice\PhpWord\TemplateProcessor;

//
$object = new Appointment;

if(isset($_POST["action"]))
{
	if($_POST["action"] == 'fetch')
	{
		
		$order_column = array('nomor');

		$output = array();
	
		$main_query = "
		SELECT id_tte,tanda_tangan_e.id_surat,nomor,file_pdf,file_word,id_user,tte FROM tanda_tangan_e INNER JOIN surat_keluar WHERE tanda_tangan_e.id_surat = surat_keluar.id_surat ";
		$search_query = '';

		if(isset($_POST["search"]["value"]))
		{
			$search_query .= 'AND (nomor LIKE "%'.$_POST["search"]["value"].'%" ';
			$search_query .= 'OR file_pdf LIKE "'.$_POST["search"]["value"].'" '; 
			$search_query .= 'OR id_user LIKE "%'.$_POST["search"]["value"].'%") '; 
		}

		if(isset($_POST["order"]))
		{
			$order_query = 'ORDER BY '.$order_column[$_POST['order']['0']['column']].' '.$_POST['order']['0']['dir'].' ';
		}
		else
		{
			$order_query = 'ORDER BY id_tte DESC ';
		}

		$limit_query = '';

		if($_POST["length"] != -1)
		{
			$limit_query .= 'LIMIT ' . $_POST['start'] . ', ' . $_POST['length'];
		}

		$object->query = $main_query . $search_query . $order_query;

		$object->execute();

		$filtered_rows = $object->row_count();

		$object->query .= $limit_query;

		$result = $object->get_result();

		$object->query = $main_query;

		$object->execute();

		$total_rows = $object->row_count();

		$data = array();

		$status = '';

		foreach($result as $row)
		{
			$sub_array = array();
			$sub_array[] = $row["nomor"];
			$sub_array[] = '<center><a href="'.$row["file_word"].'"><i class="fas fa-file-word" style="font-size:36px;color:blue"></i></a></center>';
			//
			
			$qrcode = (new QRCode($options))->render($row["tte"]);
			$sub_array[] = '<center><img src="'.$qrcode.'" width="100" height="100"></center>';
			//
			
			if($row["file_pdf"]=="") $status ='';
			else {$status = '<center><a href="'.$row["file_pdf"].'"><i class="fas fa-file-pdf" style="font-size:36px;color:red"></i></a></center>';
			}
			
			$sub_array[] = $status;

			$sub_array[] = '
			<div align="center">
			<button type="button" name="edit_button" class="btn btn-warning btn-circle btn-sm edit_button" data-id="'.$row["id_tte"].'"><i class="fas fa-edit"></i></button>
			</div>
			';
			$data[] = $sub_array;
		}

		$output = array(
			"draw"    			=> 	intval($_POST["draw"]),
			"recordsTotal"  	=>  $total_rows,
			"recordsFiltered" 	=> 	$filtered_rows,
			"data"    			=> 	$data
		);
			
		echo json_encode($output);

	}
	
	if($_POST["action"] == 'Add')
	{
		$error = '';
		$success = '';
		//
		//
		$allowed_file_format = array("docx");
		$file_extension = pathinfo($_FILES["nama_file"]["name"], PATHINFO_EXTENSION);
		if(!in_array($file_extension, $allowed_file_format))
	    {
	        $error = "<div class='alert alert-danger'>Upload hanya file .docx</div>";
	    }
	    else if (($_FILES["nama_file"]["size"] > 2000000))
	    {
	       $error = "<div class='alert alert-danger'>Ukuran File maksimum 2MB</div>";
	    }
	    else
	    {
			//
			$nama_file= date("ymhis");
			$tte = $object->base_url.'admin/index3.php?id='.$nama_file.'.pdf';
			$destination = '../docx/' .$nama_file.'.docx';
			move_uploaded_file($_FILES['nama_file']['tmp_name'], $destination);
			$nama_naskah = $destination;
			$file_pdf = '../docx/'.$nama_file.'.pdf';
			//
			$data = array(
				':nama_naskah'		=>	$nama_naskah,
				':nomor_surat'		=>	$object->clean_input($_POST["nomor_surat"])
			);
			///
			
			$object->query = "
			INSERT INTO tanda_tangan_e (id_surat, file_word, file_pdf,tte,id_user) 
			VALUES (:nomor_surat, :nama_naskah, '".$file_pdf."', '".$tte."',".$_SESSION['arsiparis_id'].")
			";

			$object->execute($data);/**/

			$success = '<div class="alert alert-success">Data Added '.$nama_naskah.'</div>';
	    }
		
			
		$output = array(
			'error'		=>	$error,
			'success'	=>	$success
		);

		echo json_encode($output);

	}

	if($_POST["action"] == 'fetch_single')
	{
		$object->query = "
		SELECT id_tte,tanda_tangan_e.id_surat,nomor,file_pdf,file_word,id_user FROM tanda_tangan_e INNER JOIN surat_keluar WHERE tanda_tangan_e.id_surat = surat_keluar.id_surat AND id_tte = '".$_POST["no_urut"]."'
		";

		$result = $object->get_result();

		$data = array();

		foreach($result as $row)
		{
			$data['nomor'] = $row['id_surat'];
			$data['file_word'] = $row['file_word'];
		}

		echo json_encode($data);
	
	}
	
	if($_POST["action"] == 'Edit')
	{
		$error = '';
		$success = '';
		$nama_naskah = '';
		$file_pdf='';
		//
		$data = array(
			//':unit_kerja'	=>	$_POST["unit_kerja"],
			':no_urut'			=>	$_POST['hidden_id']
		);
		$object->query = "
		SELECT id_tte,tanda_tangan_e.id_surat,nomor,file_pdf,file_word,id_user FROM tanda_tangan_e INNER JOIN surat_keluar WHERE tanda_tangan_e.id_surat = surat_keluar.id_surat AND id_tte = :no_urut 
		";
		
		//
		$object->execute($data);
		

		if($object->row_count() > 0)
		{
			//
			$allowed_file_format = array("pdf");
			$file_extension = pathinfo($_FILES["nama_file"]["name"], PATHINFO_EXTENSION);
			if(!in_array($file_extension, $allowed_file_format))
		    {
		        $error = "<div class='alert alert-danger'>Upload hanya file .pdf</div>";
		    }
		    else if (($_FILES["nama_file"]["size"] > 2000000))
		    {
		       $error = "<div class='alert alert-danger'>Ukuran File maksimum 2MB</div>";
		    }
		    else
		    {
		    	//
		    	$main_query = "
				SELECT file_pdf FROM tanda_tangan_e 
					WHERE id_tte='".$_POST['hidden_id']."' ";
				$object->query = $main_query ;
				$object->execute();
				$result = $object->get_result();
				foreach($result as $row)
				{
					$file_pdf = $row["file_pdf"];
				}
				//
				$destination = $file_pdf;
				move_uploaded_file($_FILES['nama_file']['tmp_name'], $destination);
				$nama_naskah = $destination;
				//
				$data = array(
					':nama_naskah'		=>	$nama_naskah,
				);
				//$object->query = 'UPDATE tanda_tangan_e  SET file_pdf = :nama_naskah
				//WHERE id_tte = '.$_POST['hidden_id'];

				//$object->execute($data);
				
				$success = '<div class="alert alert-success">Data Updated </div>';
		    }
		}
		//
		$output = array(
			'error'		=>	$error,
			'success'	=>	$success
		);
		echo json_encode($output);
	}

	if($_POST["action"] == 'beri_nomor')
	{
		//
		$nomor_naskah='';
		$format_nomor = '';
		$main_query = "
		SELECT COUNT(nomor)+1 AS nomor FROM surat_keluar 
			WHERE jenis_naskah='".$_POST["jenis_naskah"]."' AND status='1' ";
		$object->query = $main_query ;
		$object->execute();
		$result = $object->get_result();
		foreach($result as $row)
		{
			$nomor_naskah = $row["nomor"];
		}
		//if($nomor_naskah==2) $nomor_naskah=1;
		//
		$main_query2 = "
		SELECT klasifikasi,satuan_kerja,tanggal,kode_ttd FROM surat_keluar INNER JOIN jenis_naskah,satuan_kerja,tanda_tangan WHERE surat_keluar.jenis_naskah=jenis_naskah.kode_naskah AND satuan_kerja.kode_satker=surat_keluar.satker AND ttd=tanda_tangan.kode_ttd
			AND id_surat = '".$_POST["id"]."' ";
		$object->query = $main_query2 ;
		$object->execute();
		$result2 = $object->get_result();
		$klasifikasi='';
		$ttd='';
		foreach($result2 as $row)
		{
			$klasifikasi = $row["klasifikasi"];
			$ttd= $row["kode_ttd"];
		}
		//
		$array_bln	= array(1=>"I","II","III", "IV", "V","VI","VII","VIII","IX","X", "XI","XII");
		$bln		= $array_bln[date('n')];
		//
		IF($_POST["jenis_naskah"]=='SDinas'){
			$format_nomor = 'B-'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		} elseif($_POST["jenis_naskah"]=='ND'){
			$format_nomor = 'B/ND-'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		} elseif($_POST["jenis_naskah"]=='SE') {
			$format_nomor = 'SE/'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		} elseif($_POST["jenis_naskah"]=='Sprin1') {
			$format_nomor = 'Sprin/'.$nomor_naskah.'/'.$bln.'/'.$ttd.'/'.$klasifikasi.'/'.date("Y").'/BNN';
		}
		//
		$data = array(
			':nomor'	=>	$format_nomor
		);
		
		$object->query = 'UPDATE surat_keluar SET nomor =:nomor,status=1 WHERE id_surat = '.$_POST["id"];

		$object->execute($data);

		echo '<div class="alert alert-success">Nomor Surat sudah diberikan '.$format_nomor.'</div>';
	
	}
}

?>